<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:variable name="refno"></xsl:variable>
	<xsl:template match="/">
		<table id='tblvolt' width='100%' border='1' cellspacing='0' cellpadding='1' bordercolordark='#FFFFFF' bordercolor='#777777' style='font-family: Arial, Helvetica; font-size: 8pt;'>
			<tr height='24' style='color:captiontext;' bgcolor='activecaption'>
				<th colspan='12'>
					<div align='left'>
						VOLTAGE TABLE
					</div>
				</th>
			</tr>
			<tr height='23' bgcolor='threedface'>
				<th>REF</th>
				<th>PIN</th>
				<xsl:for-each select="//ROW[@NO='1']/VALUE">
					<th>
						<xsl:value-of select="@MODE"/>
					</th>
				</xsl:for-each>
			</tr>
			<xsl:if test="$refno != ''">
				<xsl:apply-templates select="//ROW[contains(@REFNO,$refno)]">
				</xsl:apply-templates>
			</xsl:if>
			<xsl:if test="$refno = ''">
				<xsl:apply-templates select="//ROW">
				</xsl:apply-templates>
			</xsl:if>
		</table>
	</xsl:template>
	
	<xsl:template match="//ROW">
		<tr height='23'>
			<xsl:attribute name="id">
				<xsl:value-of select="@BLOCKNO"/><xsl:value-of select="@REFNO"/>
			</xsl:attribute>
			<td nowrap="nowrap">
				<a id='ref'>
					<xsl:attribute name="href">
						javascript:showWaveform('<xsl:value-of select="@REFNO"/>','','<xsl:value-of select="@BLOCKNO"/>','')
					</xsl:attribute>
					<xsl:if test="@REFNO[. != '']"><xsl:value-of select="@REFNO"/></xsl:if>
					<xsl:if test="@REFNO[. = '']"><br/></xsl:if>
				</a>
			</td>
			<td nowrap="nowrap">
				<xsl:if test="@PINNO[. != '']"><xsl:value-of select="@PINNO"/></xsl:if>
				<xsl:if test="@PINNO[. = '']"><br/></xsl:if>
			</td>
			<xsl:for-each select="VALUE">
				<td nowrap="nowrap">
					<xsl:attribute name="title"><xsl:value-of select="@MODE"/></xsl:attribute>
					<xsl:if test="@LINK != ''">
						<a>
							<xsl:attribute name="href">
								javascript:showWaveform('<xsl:value-of select="../@REFNO"/>','<xsl:value-of select="../@PINNO"/>','<xsl:value-of select="../@BLOCKNO"/>','<xsl:value-of select="@MODE"/>')
							</xsl:attribute>
							<xsl:if test=". != ''"><xsl:value-of select="."/></xsl:if>
							<xsl:if test=". = ''">+++</xsl:if>
						</a>
					</xsl:if>
					<xsl:if test="@LINK = ''">
						<xsl:if test=". != ''"><xsl:value-of select="."/></xsl:if>
						<xsl:if test=". = ''"><br/></xsl:if>
					</xsl:if>
				</td>
			</xsl:for-each>
		</tr>
	</xsl:template>
	
</xsl:stylesheet>
